# chytrid.R
# Tests of independence - species vs. infection

# Load necessary libraries
library(ggplot2)
library(gmodels)

# Read in data set
chydata <- read.table(header=T,colClasses=c("factor","factor","numeric"),text="
species infected obsfreq
A  yes	 7
A  no   18
B  yes  12
B  no   38
C  yes  15
C  no   20
D  yes  27
D  no   13
")

# Print data
chydata

# Convert tabulated data to raw form for R
species <- rep(chydata[,"species"],chydata$obsfreq)
infected <- rep(chydata[,"infected"],chydata$obsfreq)

# Tests of independence
CrossTable(species,infected,expected=TRUE)

# Generate bar chart showing proportions
ggplot(chydata,aes(species,fill=infected))+
geom_bar(position="fill",aes(weight=obsfreq))+
scale_fill_grey(start=0,end=1)
